/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class MidFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type startType = parameters.getType(1);
        Object startValue = parameters.getValue(1);
        Type lengthType = parameters.getType(2);
        Object lengthValue = parameters.getValue(2);
        String text = typeRegistry.convertToText(textType, textValue);
        Number start = typeRegistry.convertToNumber(startType, startValue);
        Number length = typeRegistry.convertToNumber(lengthType, lengthValue);
        if (length.doubleValue() < 0.0 || start.doubleValue() < 1.0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(TextType.TYPE, this.process(text, start, length));
    }

    public String process(String text, Number start, Number length) {
        int lengthValue = length.intValue();
        int startValue = start.intValue() - 1;
        if (startValue >= text.length()) {
            return "";
        }
        if (lengthValue + startValue > text.length()) {
            lengthValue = text.length() - startValue;
        }
        return text.substring(startValue, startValue + lengthValue);
    }

    public String getCanonicalName() {
        return "MID";
    }
}

