/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.function.text.MidFunction;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class LeftFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int length;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String text = typeRegistry.convertToText(textType, textValue);
        if (parameterCount == 2) {
            Object lengthValue;
            Type lengthType = parameters.getType(1);
            Number lengthConv = typeRegistry.convertToNumber(lengthType, lengthValue = parameters.getValue(1));
            if (lengthConv.doubleValue() < 0.0) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            length = lengthConv.intValue();
        } else {
            length = 1;
        }
        if (text == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        MidFunction function = new MidFunction();
        return new TypeValuePair(TextType.TYPE, function.process(text, new Integer(1), new Integer(length)));
    }

    public String getCanonicalName() {
        return "LEFT";
    }
}

