/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.NumberType;

public class FindFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int index;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2 || parameterCount > 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type searchType = parameters.getType(0);
        Object searchValue = parameters.getValue(0);
        Type textType = parameters.getType(1);
        Object textValue = parameters.getValue(1);
        Type indexType = null;
        Object indexValue = null;
        if (parameterCount == 3) {
            indexType = parameters.getType(2);
            indexValue = parameters.getValue(2);
        }
        String search = typeRegistry.convertToText(searchType, searchValue);
        String text = typeRegistry.convertToText(textType, textValue);
        if (search == null || text == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int indexFrom = 0;
        if (indexType != null && indexValue != null) {
            Number n = typeRegistry.convertToNumber(indexType, indexValue);
            if (n.intValue() >= 1) {
                indexFrom = n.intValue() - 1;
            } else {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        if ((index = text.indexOf(search, indexFrom)) < 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NOT_FOUND_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(index + 1));
    }

    public String getCanonicalName() {
        return "FIND";
    }
}

