/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.math;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.typing.sequence.NumberSequence;
import org.jfree.formula.util.NumberUtil;

public class SumFunction
implements Function {
    public static final BigDecimal ZERO = new BigDecimal(0);

    public String getCanonicalName() {
        return "SUM";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        BigDecimal computedResult = ZERO;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Type type = parameters.getType(paramIdx);
            Object value = parameters.getValue(paramIdx);
            NumberSequence sequence = context.getTypeRegistry().convertToNumberSequence(type, value);
            while (sequence.hasNext()) {
                computedResult = this.compute(sequence.nextNumber(), computedResult);
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, computedResult);
    }

    private BigDecimal compute(Number value, BigDecimal computedResult) throws EvaluationException {
        if (value == null) {
            return computedResult;
        }
        return computedResult.add(NumberUtil.getAsBigDecimal(value));
    }
}

