/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.math;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.util.NumberUtil;

public class ModFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        BigDecimal divided = NumberUtil.getAsBigDecimal(context.getTypeRegistry().convertToNumber(type1, value1));
        Type type2 = parameters.getType(1);
        Object value2 = parameters.getValue(1);
        BigDecimal divisor = NumberUtil.getAsBigDecimal(context.getTypeRegistry().convertToNumber(type2, value2));
        if (divisor.signum() == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal divide = new BigDecimal(divided.divide(divisor, 0, 3).intValue());
        BigDecimal reminder = divided.subtract(divisor.multiply(divide));
        if (divide.signum() == 0 && (divided.signum() == -1 && divisor.signum() != -1 || divisor.signum() == -1 && divided.signum() != -1)) {
            reminder = divided.add(divisor);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, reminder);
    }

    public String getCanonicalName() {
        return "MOD";
    }
}

