/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.math;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.typing.sequence.NumberSequence;
import org.jfree.formula.util.NumberUtil;

public class MaxFunction
implements Function {
    public static final BigDecimal ZERO = new BigDecimal(0);

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, ZERO);
        }
        BigDecimal last = null;
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Type type = parameters.getType(paramIdx);
            Object value = parameters.getValue(paramIdx);
            NumberSequence sequence = context.getTypeRegistry().convertToNumberSequence(type, value);
            while (sequence.hasNext()) {
                BigDecimal next = NumberUtil.getAsBigDecimal(sequence.nextNumber());
                if (last == null) {
                    last = next;
                    continue;
                }
                if (last.compareTo(next) != -1) continue;
                last = next;
            }
        }
        if (last == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, last);
    }

    public String getCanonicalName() {
        return "MAX";
    }
}

