/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.logical;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.LogicalType;

public class OrFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);

    public String getCanonicalName() {
        return "OR";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int length = parameters.getParameterCount();
        for (int i = 0; i < length; ++i) {
            Type conditionType = parameters.getType(i);
            Object conditionValue = parameters.getValue(i);
            Boolean condition = context.getTypeRegistry().convertToLogical(conditionType, conditionValue);
            if (condition == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (!Boolean.TRUE.equals(condition)) continue;
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }
}

