/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.information;

import org.jfree.formula.ErrorValue;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.ErrorType;
import org.jfree.formula.typing.coretypes.LogicalType;
import org.jfree.util.Log;

public class IsNaFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        block7: {
            if (parameters.getParameterCount() != 1) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
            }
            try {
                Type type = parameters.getType(0);
                Object value = parameters.getValue(0);
                if (ErrorType.TYPE.equals(type) && value instanceof ErrorValue) {
                    Log.warn((Object)"Passing errors around is deprecated. Throw exceptions instead.");
                    ErrorValue na = (ErrorValue)value;
                    if (na.getErrorCode() == 522) {
                        return RETURN_TRUE;
                    }
                } else if (value == null) {
                    return RETURN_TRUE;
                }
            }
            catch (EvaluationException e) {
                if (e.getErrorValue().getErrorCode() != 522) break block7;
                return RETURN_TRUE;
            }
        }
        return RETURN_FALSE;
    }

    public String getCanonicalName() {
        return "ISNA";
    }
}

