/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.util.Date;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.DateTimeType;
import org.jfree.formula.util.DateUtil;

public class NowFunction
implements Function {
    public String getCanonicalName() {
        return "NOW";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        LocalizationContext localizationContext = context.getLocalizationContext();
        Date now = DateUtil.now(localizationContext);
        Date date = DateUtil.normalizeDate(now, (Type)DateTimeType.DATETIME_TYPE);
        return new TypeValuePair(DateTimeType.DATETIME_TYPE, date);
    }
}

