/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.util.Date;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.DateTimeType;

public class DateValueFunction
implements Function {
    public String getCanonicalName() {
        return "DATEVALUE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type type = parameters.getType(0);
        Object value = parameters.getValue(0);
        Date date1 = typeRegistry.convertToDate(type, value);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date1);
    }
}

