/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.sql.Date;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.DateTimeType;
import org.jfree.formula.util.DateUtil;

public class DateFunction
implements Function {
    public String getCanonicalName() {
        return "DATE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Number n1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
        Number n2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
        Number n3 = typeRegistry.convertToNumber(parameters.getType(2), parameters.getValue(2));
        if (n1 == null || n2 == null || n3 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        Date date = DateUtil.createDate(n1.intValue(), n2.intValue(), n3.intValue(), localizationContext);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }
}

