/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.formula.function.DefaultFunctionDescription;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.FunctionCategory;
import org.jfree.formula.function.FunctionDescription;
import org.jfree.formula.function.FunctionRegistry;
import org.jfree.util.Configuration;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class DefaultFunctionRegistry
implements FunctionRegistry {
    private static final String FUNCTIONS_PREFIX = "org.jfree.formula.functions.";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final FunctionCategory[] EMPTY_CATEGORIES = new FunctionCategory[0];
    private FunctionCategory[] categories;
    private HashNMap categoryFunctions;
    private HashMap functions;
    private HashMap functionMetaData;
    private HashMap cachedFunctions = new HashMap();
    static /* synthetic */ Class class$org$jfree$formula$function$FunctionDescription;

    public DefaultFunctionRegistry() {
        this.categoryFunctions = new HashNMap();
        this.functionMetaData = new HashMap();
        this.functions = new HashMap();
        this.categories = EMPTY_CATEGORIES;
    }

    public FunctionCategory[] getCategories() {
        return (FunctionCategory[])this.categories.clone();
    }

    public Function[] getFunctions() {
        String[] fnNames = this.getFunctionNames();
        ArrayList<Function> functions = new ArrayList<Function>(fnNames.length);
        for (int i = 0; i < fnNames.length; ++i) {
            String aName = fnNames[i];
            Function function = this.createFunction(aName);
            if (function == null) {
                Log.debug((Object)("There is no such function: " + aName));
                continue;
            }
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    public String[] getFunctionNames() {
        return this.functions.keySet().toArray(new String[this.functions.size()]);
    }

    public String[] getFunctionNamesByCategory(FunctionCategory category) {
        return (String[])this.categoryFunctions.toArray((Object)category, (Object[])EMPTY_ARRAY);
    }

    public Function[] getFunctionsByCategory(FunctionCategory category) {
        String[] fnNames = (String[])this.categoryFunctions.toArray((Object)category, (Object[])EMPTY_ARRAY);
        ArrayList<Function> functions = new ArrayList<Function>(fnNames.length);
        for (int i = 0; i < fnNames.length; ++i) {
            String aName = fnNames[i];
            Function function = this.createFunction(aName);
            if (function == null) continue;
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    public Function createFunction(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String functionClass = (String)this.functions.get(name.toUpperCase());
        Class cachedClass = (Class)this.cachedFunctions.get(functionClass);
        if (cachedClass != null) {
            try {
                return (Function)cachedClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        Function function = (Function)ObjectUtilities.loadAndInstantiate((String)functionClass, (Class)DefaultFunctionRegistry.class, (Class)Function.class);
        if (function == null) {
            Log.debug((Object)("There is no such function: " + name));
        } else {
            this.cachedFunctions.put(functionClass, function.getClass());
        }
        return function;
    }

    public FunctionDescription getMetaData(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (FunctionDescription)this.functionMetaData.get(name.toUpperCase());
    }

    public void initialize(Configuration configuration) {
        Iterator functionKeys = configuration.findPropertyKeys(FUNCTIONS_PREFIX);
        HashSet<FunctionCategory> categories = new HashSet<FunctionCategory>();
        while (functionKeys.hasNext()) {
            Object fn;
            String className;
            String classKey = (String)functionKeys.next();
            if (!classKey.endsWith(".class") || (className = configuration.getConfigProperty(classKey)).length() == 0 || !((fn = ObjectUtilities.loadAndInstantiate((String)className, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry") : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$Function == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.Function") : class$org$jfree$formula$function$Function))) instanceof Function)) continue;
            Function function = (Function)fn;
            int endIndex = classKey.length() - ".class".length();
            String descrKey = classKey.substring(0, endIndex) + ".description";
            String descrClassName = configuration.getConfigProperty(descrKey);
            Object descr = ObjectUtilities.loadAndInstantiate((String)descrClassName, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry") : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$FunctionDescription == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.FunctionDescription") : class$org$jfree$formula$function$FunctionDescription));
            FunctionDescription description = !(descr instanceof FunctionDescription) ? new DefaultFunctionDescription(function.getCanonicalName()) : (FunctionDescription)descr;
            FunctionCategory cat = description.getCategory();
            this.categoryFunctions.add((Object)cat, (Object)function.getCanonicalName());
            this.functionMetaData.put(function.getCanonicalName(), description);
            this.functions.put(function.getCanonicalName(), className);
            categories.add(cat);
        }
        this.categories = categories.toArray(new FunctionCategory[categories.size()]);
    }
}

