/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.jfree.fonts.FontException;
import org.jfree.fonts.registry.AbstractFontFileRegistry;
import org.jfree.fonts.registry.DefaultFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.truetype.NameTable;
import org.jfree.fonts.truetype.TrueTypeCollection;
import org.jfree.fonts.truetype.TrueTypeFont;
import org.jfree.fonts.truetype.TrueTypeFontMetricsFactory;
import org.jfree.fonts.truetype.TrueTypeFontRecord;
import org.jfree.util.Log;
import org.jfree.util.StringUtils;

public class TrueTypeFontRegistry
extends AbstractFontFileRegistry {
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private HashMap seenFiles = new HashMap();
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();

    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    protected boolean isCached(File file) {
        try {
            FontFileRecord stored = (FontFileRecord)this.seenFiles.get(file.getCanonicalPath());
            if (stored == null) {
                return false;
            }
            FontFileRecord rec = new FontFileRecord(file);
            if (!stored.equals(rec)) {
                this.seenFiles.remove(rec);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFont(File file, String encoding) throws IOException {
        try {
            if (StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                int i = 0;
                while ((long)i < ttc.getNumFonts()) {
                    TrueTypeFont font = null;
                    try {
                        font = ttc.getFont(i);
                        this.registerTrueTypeFont(font);
                    }
                    finally {
                        if (font != null) {
                            font.dispose();
                        }
                    }
                    ++i;
                }
            } else {
                TrueTypeFont font = null;
                try {
                    font = new TrueTypeFont(file);
                    this.registerTrueTypeFont(font);
                }
                finally {
                    if (font != null) {
                        font.dispose();
                    }
                }
            }
            FontFileRecord value = new FontFileRecord(file);
            this.seenFiles.put(file.getCanonicalPath(), value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTrueTypeFont(TrueTypeFont font) throws IOException {
        NameTable table = (NameTable)font.getTable(1851878757L);
        if (table == null) {
            throw new IOException("The NameTable is required for all conforming fonts.");
        }
        String familyName = table.getPrimaryName(1);
        String[] allNames = table.getAllNames(1);
        DefaultFontFamily fontFamily = this.createFamily(familyName);
        this.alternateFamilyNames.put(familyName, fontFamily);
        for (int i = 0; i < allNames.length; ++i) {
            String name = allNames[i];
            fontFamily.addName(name);
            this.alternateFamilyNames.put(name, fontFamily);
        }
        String[] allFullNames = table.getAllNames(4);
        for (int i = 0; i < allFullNames.length; ++i) {
            String name = allFullNames[i];
            this.fullFontNames.put(name, fontFamily);
        }
        try {
            TrueTypeFontRecord record = new TrueTypeFontRecord(font, fontFamily);
            fontFamily.addFontRecord(record);
        }
        catch (FontException e) {
            Log.info((Object)("The font '" + font.getFilename() + "' is invalid."));
        }
    }

    private DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = (DefaultFontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        DefaultFontFamily createdFamily = new DefaultFontFamily(name);
        this.fontFamilies.put(name, createdFamily);
        return createdFamily;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    public FontFamily getFontFamily(String name) {
        FontFamily primary = (FontFamily)this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = (FontFamily)this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return (FontFamily)this.fullFontNames.get(name);
    }

    public FontMetricsFactory createMetricsFactory() {
        return new TrueTypeFontMetricsFactory();
    }

    private static class FontPathFilter
    implements FileFilter,
    Serializable {
        protected FontPathFilter() {
        }

        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttf")) {
                return true;
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)".ttc")) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase((String)name, (String)".otf");
        }
    }

    private static class FontFileRecord
    implements Serializable {
        private long lastAccessTime;
        private long fileSize;
        private String filename;

        protected FontFileRecord(File file) throws IOException {
            this(file.getCanonicalPath(), file.length(), file.lastModified());
        }

        protected FontFileRecord(String filename, long fileSize, long lastAccessTime) {
            if (filename == null) {
                throw new NullPointerException();
            }
            this.filename = filename;
            this.fileSize = fileSize;
            this.lastAccessTime = lastAccessTime;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontFileRecord that = (FontFileRecord)o;
            if (this.fileSize != that.fileSize) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
            return this.filename.equals(that.filename);
        }

        public int hashCode() {
            int result = (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
            result = 29 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
            result = 29 * result + this.filename.hashCode();
            return result;
        }
    }
}

