/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.IOException;
import java.util.HashMap;
import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontType;
import org.jfree.fonts.truetype.ScalableTrueTypeFontMetrics;
import org.jfree.fonts.truetype.TrueTypeFont;
import org.jfree.fonts.truetype.TrueTypeFontIdentifier;
import org.jfree.fonts.truetype.TrueTypeFontMetrics;
import org.jfree.util.Log;

public class TrueTypeFontMetricsFactory
implements FontMetricsFactory {
    private HashMap fontRecords = new HashMap();

    public FontMetrics createMetrics(FontIdentifier record, FontContext context) {
        if (!FontType.OPENTYPE.equals(record.getFontType())) {
            throw new IllegalArgumentException("This identifier does not belong to the OpenType-font system.");
        }
        TrueTypeFontIdentifier ttfId = (TrueTypeFontIdentifier)record;
        ScalableTrueTypeFontMetrics fromCache = (ScalableTrueTypeFontMetrics)this.fontRecords.get(ttfId);
        if (fromCache != null) {
            return new TrueTypeFontMetrics(fromCache, context.getFontSize());
        }
        try {
            FontDataInputSource fdis = ttfId.getInputSource();
            TrueTypeFont font = new TrueTypeFont(fdis);
            ScalableTrueTypeFontMetrics fontMetrics = new ScalableTrueTypeFontMetrics(font);
            this.fontRecords.put(ttfId, fontMetrics);
            return new TrueTypeFontMetrics(fontMetrics, context.getFontSize());
        }
        catch (IOException e) {
            Log.warn((Object)"Unable to read the font.", (Exception)e);
            throw new IllegalStateException();
        }
    }
}

