/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.tools.StrictGeomUtility;
import org.jfree.fonts.truetype.ScalableTrueTypeFontMetrics;

public class TrueTypeFontMetrics
implements FontMetrics {
    private ScalableTrueTypeFontMetrics fontMetrics;
    private double fontSize;

    public TrueTypeFontMetrics(ScalableTrueTypeFontMetrics fontMetrics, double fontSize) {
        if (fontMetrics == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.fontMetrics = fontMetrics;
        this.fontSize = fontSize;
    }

    public long getAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getAscent());
    }

    public long getDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getDescent());
    }

    public long getLeading() {
        return (long)(this.fontSize * (double)this.fontMetrics.getLeading());
    }

    public long getXHeight() {
        return (long)(this.fontSize * (double)this.fontMetrics.getXHeight());
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, StrictGeomUtility.toInternalValue(this.fontSize) / 20L);
    }

    public long getUnderlinePosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getUnderlinePosition());
    }

    public long getStrikeThroughPosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getStrikeThroughPosition());
    }

    public long getMaxAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxAscent());
    }

    public long getMaxDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxDescent());
    }

    public long getItalicAngle() {
        return this.fontMetrics.getItalicAngle();
    }

    public long getMaxHeight() {
        return (long)((double)(this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading()) * this.fontSize);
    }

    public long getMaxCharAdvance() {
        return (long)((double)this.fontMetrics.getMaxCharAdvance() * this.fontSize);
    }

    public long getCharWidth(int character) {
        return 0L;
    }

    public long getKerning(int previous, int character) {
        return 0L;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

