/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontType;

public class TrueTypeFontIdentifier
implements FontIdentifier {
    private FontDataInputSource inputSource;
    private String fontName;
    private String fontVariant;
    private int collectionIndex;
    private long offset;

    public TrueTypeFontIdentifier(FontDataInputSource inputSource, String fontName, String fontVariant, int collectionIndex, long offset) {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        if (fontName == null) {
            throw new NullPointerException();
        }
        if (fontVariant == null) {
            throw new NullPointerException();
        }
        this.fontVariant = fontVariant;
        this.inputSource = inputSource;
        this.fontName = fontName;
        this.collectionIndex = collectionIndex;
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontIdentifier that = (TrueTypeFontIdentifier)o;
        if (this.collectionIndex != that.collectionIndex) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!((Object)this.inputSource).equals(that.inputSource)) {
            return false;
        }
        if (!this.fontName.equals(that.fontName)) {
            return false;
        }
        return this.fontVariant.equals(that.fontVariant);
    }

    public int hashCode() {
        int result = this.fontName.hashCode();
        result = 29 * result + ((Object)this.inputSource).hashCode();
        result = 29 * result + this.fontVariant.hashCode();
        result = 29 * result + this.collectionIndex;
        result = 29 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public FontDataInputSource getInputSource() {
        return this.inputSource;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.OPENTYPE;
    }
}

