/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.tools;

import java.io.Serializable;
import java.util.Arrays;

public class ByteTable
implements Serializable {
    private static final long serialVersionUID = -276004279213053063L;
    private int rows;
    private int columns;
    private byte[][] data;

    public ByteTable(int rows, int cols) {
        if (rows < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (cols < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = rows;
        this.columns = cols;
        this.data = new byte[rows][];
    }

    public void ensureCapacity(int row, int column) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("Row is invalid. " + row);
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("Column is invalid. " + column);
        }
        byte[] current = this.data[row];
        if (current == null) {
            this.data[row] = new byte[Math.max(column + 1, this.columns)];
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public byte getByte(int row, int column, byte defaultValue) {
        if (row < this.data.length) {
            byte[] current = this.data[row];
            if (current == null) {
                return defaultValue;
            }
            if (column < current.length) {
                return current[column];
            }
        }
        return defaultValue;
    }

    public void setByte(int row, int column, byte object) {
        this.ensureCapacity(row, column);
        this.data[row][column] = object;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteTable)) {
            return false;
        }
        ByteTable ot = (ByteTable)o;
        if (this.getRowCount() != ot.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != ot.getColumnCount()) {
            return false;
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                if (this.getByte(r, c, (byte)-1) == ot.getByte(r, c, (byte)-1)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.rows;
        result = 29 * result + this.columns;
        return result;
    }

    public void clear(byte value) {
        this.rows = 0;
        this.columns = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            Arrays.fill(this.data[i], value);
        }
    }

    protected void setData(byte[][] data, int colCount) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (colCount < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.data = data;
        this.rows = data.length;
        this.columns = colCount;
    }

    protected byte[][] getData() {
        return this.data;
    }
}

