/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text;

public class Spacing {
    public static final Spacing EMPTY_SPACING = new Spacing(0, 0, 0);
    private int minimum;
    private int maximum;
    private int optimum;

    public Spacing(int minimum, int optimum, int maximum) {
        if (minimum > maximum) {
            this.minimum = minimum;
            this.maximum = minimum;
            this.optimum = minimum;
        } else {
            this.minimum = minimum;
            this.maximum = maximum;
            this.optimum = optimum < this.minimum ? this.minimum : (optimum > this.maximum ? this.maximum : optimum);
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getOptimum() {
        return this.optimum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spacing spacing = (Spacing)o;
        if (this.maximum != spacing.maximum) {
            return false;
        }
        if (this.minimum != spacing.minimum) {
            return false;
        }
        return this.optimum == spacing.optimum;
    }

    public int hashCode() {
        int result = this.minimum;
        result = 29 * result + this.maximum;
        result = 29 * result + this.optimum;
        return result;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append("={minimum=");
        b.append(this.minimum);
        b.append(", optimum=");
        b.append(this.optimum);
        b.append(", maximum=");
        b.append(this.maximum);
        b.append('}');
        return b.toString();
    }
}

