/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import org.jfree.fonts.registry.FontIdentifier;

public class FontKey {
    private FontIdentifier identifier;
    private boolean aliased;
    private boolean fractional;
    private double fontSize;

    public FontKey(FontIdentifier identifier, boolean aliased, boolean fractional, double fontSize) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        this.identifier = identifier;
        this.aliased = aliased;
        this.fractional = fractional;
        this.fontSize = fontSize;
    }

    public FontKey() {
    }

    public FontIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(FontIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isAliased() {
        return this.aliased;
    }

    public void setAliased(boolean aliased) {
        this.aliased = aliased;
    }

    public boolean isFractional() {
        return this.fractional;
    }

    public void setFractional(boolean fractional) {
        this.fractional = fractional;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontKey fontKey = (FontKey)o;
        if (this.aliased != fontKey.aliased) {
            return false;
        }
        if (fontKey.fontSize != this.fontSize) {
            return false;
        }
        if (this.fractional != fontKey.fractional) {
            return false;
        }
        return ((Object)this.identifier).equals(fontKey.identifier);
    }

    public int hashCode() {
        int result = ((Object)this.identifier).hashCode();
        result = 29 * result + (this.aliased ? 1 : 0);
        result = 29 * result + (this.fractional ? 1 : 0);
        long temp = this.fontSize == 0.0 ? 0L : Double.doubleToLongBits(this.fontSize);
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

