/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.tools.StrictGeomUtility;

public class EmptyFontMetrics
implements FontMetrics {
    private long baseSize;
    private long baseWidth;

    public EmptyFontMetrics(double baseWidth, double baseHeight) {
        this.baseSize = StrictGeomUtility.toInternalValue(baseHeight);
        this.baseWidth = StrictGeomUtility.toInternalValue(baseWidth);
    }

    public EmptyFontMetrics(long baseWidth, long baseHeight) {
        this.baseWidth = baseWidth;
        this.baseSize = baseHeight;
    }

    public long getAscent() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.7);
    }

    public long getDescent() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.3);
    }

    public long getLeading() {
        return 0L;
    }

    public long getXHeight() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.5);
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.baseSize / 20L);
    }

    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.baseSize / 20L);
    }

    public long getStrikeThroughPosition() {
        return StrictGeomUtility.toInternalValue((double)this.getXHeight() * 0.5);
    }

    public long getMaxAscent() {
        return this.getAscent();
    }

    public long getMaxDescent() {
        return this.getDescent();
    }

    public long getMaxHeight() {
        return this.baseSize;
    }

    public long getMaxCharAdvance() {
        return this.baseWidth;
    }

    public long getCharWidth(int codePoint) {
        return this.baseWidth;
    }

    public long getKerning(int previous, int codePoint) {
        return 0L;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        if (info == null) {
            info = new BaselineInfo();
        }
        long maxAscent = this.getMaxAscent();
        info.setBaseline(1, maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2L);
        info.setBaseline(4, maxAscent);
        info.setBaseline(2, maxAscent / 2L);
        info.setBaseline(0, maxAscent - this.getXHeight());
        info.setDominantBaseline(4);
        return info;
    }

    public long getItalicAngle() {
        return 0L;
    }
}

