/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import java.util.HashMap;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontKey;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontStorage;

public class DefaultFontStorage
implements FontStorage {
    private HashMap knownMetrics = new HashMap();
    private FontRegistry registry;
    private FontMetricsFactory metricsFactory;
    private FontKey lookupKey;

    public DefaultFontStorage(FontRegistry registry) {
        this.registry = registry;
        this.metricsFactory = registry.createMetricsFactory();
        this.lookupKey = new FontKey();
    }

    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    public FontMetrics getFontMetrics(FontIdentifier record, FontContext context) {
        if (record == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(record);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        FontMetrics cachedMetrics = (FontMetrics)this.knownMetrics.get(this.lookupKey);
        if (cachedMetrics != null) {
            return cachedMetrics;
        }
        FontKey key = new FontKey(record, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize());
        FontMetrics metrics = this.metricsFactory.createMetrics(record, context);
        this.knownMetrics.put(key, metrics);
        return metrics;
    }
}

