/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.registry;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.jfree.fonts.LibFontBoot;
import org.jfree.fonts.encoding.EncodingRegistry;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.util.Log;
import org.jfree.util.StringUtils;

public abstract class AbstractFontFileRegistry
implements FontRegistry {
    protected abstract FileFilter getFileFilter();

    public void initialize() {
        this.registerDefaultFontPath();
    }

    protected String getDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.fonts.itext.FontEncoding", EncodingRegistry.getPlatformDefaultEncoding());
    }

    public synchronized void registerDefaultFontPath() {
        String encoding = this.getDefaultEncoding();
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        Log.debug((Object)("Running on operating system: " + osname));
        Log.debug((Object)("Character encoding used as default: " + encoding));
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            Log.debug((Object)"Detected MacOS (Property 'mrj.version' is present.");
            this.registerFontPath(new File(userhome + "/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Network/Library/Fonts"), encoding);
            this.registerFontPath(new File("/System/Library/Fonts"), encoding);
        } else if (StringUtils.startsWithIgnoreCase((String)osname, (String)"windows")) {
            this.registerWindowsFontPath(encoding);
        } else {
            Log.debug((Object)"Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), encoding);
            this.registerFontPath(new File("/usr/share/fonts"), encoding);
        }
        this.registerFontPath(new File(jrepath, "lib" + fs + "fonts"), encoding);
        Log.info((Object)"Completed font registration.");
    }

    private void registerWindowsFontPath(String encoding) {
        Log.debug((Object)"Found 'Windows' in the OS name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtils.endsWithIgnoreCase((String)token, (String)"System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                if (lastBackslash != -1) {
                    fontPath = token.substring(0, lastBackslash) + fs + "Fonts";
                    break;
                }
                int lastSlash = token.lastIndexOf(47);
                if (lastSlash == -1) continue;
                fontPath = token.substring(0, lastSlash) + lastSlash + "Fonts";
                break;
            }
        }
        Log.debug((Object)("Fonts located in \"" + fontPath + '\"'));
        if (fontPath != null) {
            File file = new File(fontPath);
            this.registerFontPath(file, encoding);
        }
    }

    public synchronized void registerFontPath(File file, String encoding) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            File[] files = file.listFiles(this.getFileFilter());
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (currentFile.isDirectory()) {
                    this.registerFontPath(currentFile, encoding);
                    continue;
                }
                if (this.isCached(currentFile)) continue;
                this.registerFontFile(currentFile, encoding);
            }
        }
    }

    protected boolean isCached(File file) {
        return false;
    }

    public synchronized void registerFontFile(String filename, String encoding) {
        File file = new File(filename);
        this.registerFontFile(file, encoding);
    }

    public void registerFontFile(File file, String encoding) {
        if (this.getFileFilter().accept(file) && file.exists() && file.isFile() && file.canRead()) {
            try {
                this.addFont(file, encoding);
            }
            catch (Exception e) {
                Log.warn((Object)new Log.SimpleMessage("Font ", (Object)file, (Object)" is invalid. Message:", (Object)e.getMessage()), (Exception)e);
            }
        }
    }

    protected abstract void addFont(File var1, String var2) throws IOException;

    protected String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }
}

