/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.pfm;

import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.fonts.pfm.PfmFont;
import org.jfree.fonts.pfm.PfmFontHeader;
import org.jfree.fonts.registry.DefaultFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontSource;
import org.jfree.fonts.registry.FontType;

public class PfmFontRecord
implements FontSource,
FontIdentifier {
    private PfmFont font;
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;

    public PfmFontRecord(PfmFont font, DefaultFontFamily fontFamily) {
        this.font = font;
        this.fontFamily = fontFamily;
        PfmFontHeader header = font.getHeader();
        this.bold = header.getWeight() > 400;
        this.italic = header.isItalic();
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isOblique() {
        return false;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public String getFontFile() {
        return this.font.getFilename();
    }

    public FontDataInputSource getFontInputSource() {
        return this.font.getInput();
    }

    public boolean isEmbeddable() {
        return this.font.isEmbeddable();
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.PFM;
    }
}

