/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.pfm;

import org.jfree.fonts.LEByteAccessUtilities;

public class PfmFontHeader {
    public static final int LENGTH = 117;
    private short version;
    private long size;
    private short type;
    private short point;
    private short vertRes;
    private short horizRes;
    private short ascent;
    private short internalLeading;
    private short externalLeading;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private short weight;
    private byte charset;
    private short pixelWidth;
    private short pixelHeight;
    private byte pitchAndFamily;
    private short avgWidth;
    private short maxWidth;
    private short firstChar;
    private short lastChar;
    private short defaultChar;
    private short breakChar;
    private short widthBytes;
    private int devicePtr;
    private int facePtr;

    public PfmFontHeader(byte[] data) {
        this.version = LEByteAccessUtilities.readShort(data, 0);
        this.size = LEByteAccessUtilities.readULong(data, 2);
        this.type = LEByteAccessUtilities.readShort(data, 66);
        this.point = LEByteAccessUtilities.readShort(data, 68);
        this.vertRes = LEByteAccessUtilities.readShort(data, 70);
        this.horizRes = LEByteAccessUtilities.readShort(data, 72);
        this.ascent = LEByteAccessUtilities.readShort(data, 74);
        this.internalLeading = LEByteAccessUtilities.readShort(data, 76);
        this.externalLeading = LEByteAccessUtilities.readShort(data, 78);
        this.italic = data[80] != 0;
        this.underline = data[81] != 0;
        this.strikeout = data[82] != 0;
        this.weight = LEByteAccessUtilities.readShort(data, 83);
        this.charset = data[85];
        this.pixelWidth = LEByteAccessUtilities.readShort(data, 86);
        this.pixelHeight = LEByteAccessUtilities.readShort(data, 88);
        this.pitchAndFamily = data[90];
        this.avgWidth = LEByteAccessUtilities.readShort(data, 91);
        this.maxWidth = LEByteAccessUtilities.readShort(data, 93);
        this.firstChar = (short)(0xFF & data[95]);
        this.lastChar = (short)(0xFF & data[96]);
        this.defaultChar = (short)(0xFF & data[97]);
        this.breakChar = (short)(0xFF & data[98]);
        this.widthBytes = LEByteAccessUtilities.readShort(data, 99);
        this.devicePtr = LEByteAccessUtilities.readLong(data, 101);
        this.facePtr = LEByteAccessUtilities.readLong(data, 105);
    }

    public int getDevicePtr() {
        return this.devicePtr;
    }

    public int getFacePtr() {
        return this.facePtr;
    }

    public short getVersion() {
        return this.version;
    }

    public long getSize() {
        return this.size;
    }

    public short getType() {
        return this.type;
    }

    public short getPoint() {
        return this.point;
    }

    public short getVertRes() {
        return this.vertRes;
    }

    public short getHorizRes() {
        return this.horizRes;
    }

    public short getAscent() {
        return this.ascent;
    }

    public short getInternalLeading() {
        return this.internalLeading;
    }

    public short getExternalLeading() {
        return this.externalLeading;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public short getWeight() {
        return this.weight;
    }

    public byte getCharset() {
        return this.charset;
    }

    public short getPixelWidth() {
        return this.pixelWidth;
    }

    public short getPixelHeight() {
        return this.pixelHeight;
    }

    public byte getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public short getAvgWidth() {
        return this.avgWidth;
    }

    public short getMaxWidth() {
        return this.maxWidth;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getDefaultChar() {
        return this.defaultChar;
    }

    public short getBreakChar() {
        return this.breakChar;
    }

    public short getWidthBytes() {
        return this.widthBytes;
    }

    public String getEncoding() {
        switch (this.charset) {
            case 128: {
                return "SJIS";
            }
            case 129: {
                return "EUC_KR";
            }
            case 134: {
                return "GBK";
            }
            case 136: {
                return "Big5";
            }
        }
        return "Cp1252";
    }
}

