/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.monospace;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;

public class MonospaceFontMetrics
implements FontMetrics {
    private static final long MICRO_DOTS_PER_INCH = 72000L;
    private long charHeight;
    private long charWidth;

    public MonospaceFontMetrics(float cpi, float lpi) {
        this.charHeight = (long)(72000.0f / lpi);
        this.charWidth = (long)(72000.0f / cpi);
    }

    public long getAscent() {
        return (long)(0.7 * (double)this.charHeight);
    }

    public long getDescent() {
        return (long)(0.3 * (double)this.charHeight);
    }

    public long getLeading() {
        return 0L;
    }

    public long getXHeight() {
        return (long)(0.5 * (double)this.charHeight);
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.charHeight / 20L);
    }

    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.charHeight / 20L);
    }

    public long getStrikeThroughPosition() {
        return (long)(0.5 * (double)this.getXHeight());
    }

    public long getMaxAscent() {
        return this.getAscent();
    }

    public long getMaxDescent() {
        return this.getDescent();
    }

    public long getMaxHeight() {
        return this.charHeight;
    }

    public long getMaxCharAdvance() {
        return this.charWidth;
    }

    public long getCharWidth(int codePoint) {
        return this.charWidth;
    }

    public long getKerning(int previous, int codePoint) {
        return 0L;
    }

    public long getItalicAngle() {
        return 0L;
    }

    public BaselineInfo getBaselines(int codePoint, BaselineInfo info) {
        if (info == null) {
            info = new BaselineInfo();
        }
        info.setBaseline(0, 0L);
        info.setBaseline(1, this.charHeight / 2L);
        info.setBaseline(2, this.charHeight / 2L);
        info.setBaseline(3, this.charHeight / 2L);
        info.setBaseline(4, this.getMaxAscent());
        info.setBaseline(5, this.getMaxHeight());
        return info;
    }
}

