/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.monospace;

import org.jfree.fonts.monospace.MonospaceFontRecord;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;

public class MonospaceFontFamily
implements FontFamily {
    private String familyName;
    private FontRecord[] fonts;

    public MonospaceFontFamily(String familyName) {
        if (familyName == null) {
            throw new NullPointerException();
        }
        this.familyName = familyName;
        this.fonts = new FontRecord[4];
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String[] getAllNames() {
        return new String[]{this.familyName};
    }

    public FontRecord getFontRecord(boolean bold, boolean italics) {
        int index = 0;
        if (bold) {
            ++index;
        }
        if (italics) {
            index += 2;
        }
        if (this.fonts[index] != null) {
            return this.fonts[index];
        }
        this.fonts[index] = new MonospaceFontRecord(this, bold, italics);
        return this.fonts[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonospaceFontFamily that = (MonospaceFontFamily)o;
        return this.familyName.equals(that.familyName);
    }

    public int hashCode() {
        return this.familyName.hashCode();
    }
}

