/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.merge;

import java.util.ArrayList;
import java.util.HashSet;
import org.jfree.fonts.merge.CompoundFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;

public class CompoundFontRegistry
implements FontRegistry {
    private ArrayList registries = new ArrayList();

    public void addRegistry(FontRegistry registry) {
        if (registry == null) {
            throw new NullPointerException();
        }
        this.registries.add(registry);
    }

    public void initialize() {
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            fontRegistry.initialize();
        }
    }

    public FontFamily getFontFamily(String name) {
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            FontFamily fontFamily = fontRegistry.getFontFamily(name);
            if (fontFamily == null) continue;
            return new CompoundFontFamily(fontFamily, fontRegistry);
        }
        return null;
    }

    public String[] getRegisteredFamilies() {
        HashSet<String> registeredFamilies = new HashSet<String>();
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            String[] fontFamilies = fontRegistry.getRegisteredFamilies();
            for (int j = 0; j < fontFamilies.length; ++j) {
                String fontFamily = fontFamilies[j];
                registeredFamilies.add(fontFamily);
            }
        }
        return registeredFamilies.toArray(new String[registeredFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        HashSet<String> registeredFamilies = new HashSet<String>();
        for (int i = 0; i < this.registries.size(); ++i) {
            FontRegistry fontRegistry = (FontRegistry)this.registries.get(i);
            String[] fontFamilies = fontRegistry.getAllRegisteredFamilies();
            for (int j = 0; j < fontFamilies.length; ++j) {
                String fontFamily = fontFamilies[j];
                registeredFamilies.add(fontFamily);
            }
        }
        return registeredFamilies.toArray(new String[registeredFamilies.size()]);
    }

    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException("The CompoundFontRegistry cannot provide font-metrics directly.");
    }
}

