/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;

public class ResourceFontDataInputSource
implements FontDataInputSource {
    private transient byte[] rawData;
    private ResourceManager loader;
    private ResourceKey source;

    public ResourceFontDataInputSource(ResourceManager loader, ResourceKey source) {
        if (loader == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        this.loader = loader;
        this.source = source;
    }

    public void readFullyAt(long position, byte[] buffer, int offset, int length) throws IOException {
        int iPos;
        int endPos;
        if (this.rawData == null) {
            try {
                ResourceData data = this.loader.load(this.source);
                this.rawData = data.getResource(this.loader);
            }
            catch (ResourceLoadingException e) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        if ((endPos = (iPos = (int)(position & Integer.MAX_VALUE)) + length) < 0 || endPos > this.rawData.length) {
            throw new EOFException("The input source reached the End-Of-Stream.");
        }
        System.arraycopy(this.rawData, iPos, buffer, offset, length);
    }

    public int readAt(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.rawData == null) {
            try {
                ResourceData data = this.loader.load(this.source);
                this.rawData = data.getResource(this.loader);
            }
            catch (ResourceLoadingException e) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        int iPos = (int)(position & Integer.MAX_VALUE);
        int readLength = Math.min(length, this.rawData.length - iPos);
        System.arraycopy(this.rawData, iPos, buffer, offset, readLength);
        return readLength;
    }

    public int readAt(long position) throws IOException {
        int iPos;
        if (this.rawData == null) {
            try {
                ResourceData data = this.loader.load(this.source);
                this.rawData = data.getResource(this.loader);
            }
            catch (ResourceLoadingException e) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        if ((iPos = (int)(position & Integer.MAX_VALUE)) >= this.rawData.length) {
            return -1;
        }
        return this.rawData[iPos];
    }

    public void dispose() {
        this.rawData = null;
    }

    public String getFileName() {
        Object identifier = this.source.getIdentifier();
        if (identifier instanceof File) {
            File f = (File)identifier;
            return f.getPath();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFontDataInputSource that = (ResourceFontDataInputSource)o;
        if (!this.loader.equals(that.loader)) {
            return false;
        }
        return this.source.equals((Object)that.source);
    }

    public int hashCode() {
        int result = this.loader.hashCode();
        result = 29 * result + this.source.hashCode();
        return result;
    }
}

