/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding.manual;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.jfree.fonts.encoding.ByteBuffer;
import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.Encoding;
import org.jfree.fonts.encoding.EncodingErrorType;
import org.jfree.fonts.encoding.EncodingException;
import org.jfree.fonts.encoding.manual.Utf16LE;

public class BuiltInJavaEncoding
implements Encoding {
    private String name;
    private boolean fastMode;

    public BuiltInJavaEncoding(String name, boolean fastMode) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.fastMode = fastMode;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer) throws EncodingException {
        try {
            byte[] rawData = text.getData();
            String decoded = new String(rawData, text.getOffset(), text.getLength(), this.name);
            return Utf16LE.getInstance().decodeString(decoded, buffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("Failed to encode the string: " + e.getMessage());
        }
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        return this.decode(text, buffer);
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer) throws EncodingException {
        String javaText = Utf16LE.getInstance().encodeString(text);
        try {
            byte[] data = javaText.getBytes(this.name);
            int textLength = text.getLength();
            if (buffer == null) {
                buffer = new ByteBuffer(textLength * 2);
            } else if (buffer.getLength() * 2 < textLength) {
                buffer.ensureSize(textLength * 2);
            }
            System.arraycopy(data, 0, buffer.getData(), buffer.getOffset(), data.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("Failed to encode the string: " + e.getMessage());
        }
        return buffer;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        return this.encode(text, buffer);
    }

    public String getName() {
        return this.name;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public boolean isUnicodeCharacterSupported(int c) {
        if (this.fastMode) {
            return true;
        }
        if (c == 63) {
            return true;
        }
        String testEncoding = String.valueOf((char)c);
        try {
            byte[] bytes = testEncoding.getBytes(this.name);
            if (bytes.length != 1) {
                return true;
            }
            return 63 != bytes[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to encode the string: " + e.getMessage());
        }
    }
}

