/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.jfree.fonts.encoding.Encoding;
import org.jfree.fonts.encoding.External8BitEncodingCore;
import org.jfree.fonts.encoding.External8BitEncodingData;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.SimpleResource;

public class EncodingFactory
implements ResourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        SimpleResource simpleResource;
        InputStream in = data.getResourceAsStream(manager);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            Object ob = oin.readObject();
            if (!(ob instanceof External8BitEncodingData)) {
                throw new ResourceCreationException("This is no 8Bit Encoding data");
            }
            External8BitEncodingData encData = (External8BitEncodingData)ob;
            External8BitEncodingCore encCore = new External8BitEncodingCore(encData);
            simpleResource = new SimpleResource(data.getKey(), (Object)encCore, data.getVersion(manager));
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Failed to load resource", (Exception)e);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceCreationException("Missing class definition: Failed to create encoding.");
            }
        }
        oin.close();
        return simpleResource;
    }

    public Class getFactoryType() {
        return Encoding.class;
    }

    public void initializeDefaults() {
    }
}

