/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.manual.Utf16LE;

public class CodePointUtilities {
    public static boolean isValidCodePoint(int cp) {
        if (cp > 0x10FFFF) {
            return false;
        }
        if (cp > 57343) {
            return true;
        }
        if (cp >= 56320) {
            return false;
        }
        return cp >= 0;
    }

    public static int toChars(int cp, char[] buffer, int offset) {
        if (cp < 65536) {
            if (offset >= buffer.length) {
                return -1;
            }
            buffer[offset] = cp < 0 ? 65535 : (cp >= 56320 && cp < 57344 ? 65535 : (char)(cp & 0xFFFF));
            return 1;
        }
        if (cp > 0x10FFFF) {
            if (offset >= buffer.length) {
                return -1;
            }
            buffer[offset] = 65535;
            return 1;
        }
        if (offset + 1 >= buffer.length) {
            return -2;
        }
        int derivedSourceItem = cp - 65536;
        int highWord = 0xD800 | (derivedSourceItem & 0xFFC00) >> 10;
        int lowWord = 0xDC00 | derivedSourceItem & 0x3FF;
        buffer[offset] = (char)highWord;
        buffer[offset + 1] = (char)lowWord;
        return 2;
    }

    public static int[] charsToCodepoint(String text) {
        CodePointBuffer buffer = Utf16LE.getInstance().decodeString(text, null);
        return buffer.getBuffer();
    }

    public static String codepointToChars(int[] text) {
        CodePointBuffer buffer = new CodePointBuffer(text);
        buffer.setCursor(text.length);
        return Utf16LE.getInstance().encodeString(buffer);
    }

    private CodePointUtilities() {
    }
}

