/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import org.jfree.fonts.encoding.CodePointBuffer;

public class CodePointStream {
    private CodePointBuffer buffer;
    private int[] data;
    private int cursor;
    private int lastWritePos;
    private int increment;

    public CodePointStream(CodePointBuffer buffer, int increment) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (increment < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.data = buffer.getData();
        this.cursor = buffer.getCursor();
        this.lastWritePos = this.data.length - 1;
        this.increment = increment;
    }

    public void put(int b) {
        if (this.cursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.cursor + this.increment);
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        this.data[this.cursor] = b;
        ++this.cursor;
    }

    public void put(int[] b) {
        if (this.cursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.cursor + Math.max(this.increment, b.length));
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        System.arraycopy(b, 0, this.data, this.cursor, b.length);
        this.cursor += b.length;
    }

    public void close() {
        this.buffer.setCursor(this.cursor);
    }
}

