/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.encoding;

import org.jfree.fonts.encoding.ByteBuffer;

public class ByteStream {
    private ByteBuffer buffer;
    private byte[] data;
    private int writeCursor;
    private int lastWritePos;
    private int increment;
    private int readCursor;

    public ByteStream(ByteBuffer buffer, int increment) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (increment < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.data = buffer.getData();
        this.writeCursor = buffer.getCursor();
        this.lastWritePos = this.data.length - 1;
        this.increment = increment;
        this.readCursor = buffer.getOffset();
    }

    public void put(byte b) {
        if (this.writeCursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.writeCursor + this.increment);
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        this.data[this.writeCursor] = b;
        ++this.writeCursor;
    }

    public void put(byte[] b) {
        if (this.writeCursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.writeCursor + Math.max(this.increment, b.length));
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        System.arraycopy(b, 0, this.data, this.writeCursor, b.length);
        this.writeCursor += b.length;
    }

    public byte get() {
        if (this.readCursor < this.writeCursor) {
            byte retval = this.data[this.readCursor];
            ++this.readCursor;
            return retval;
        }
        return 0;
    }

    public void close() {
        this.buffer.setCursor(this.writeCursor);
    }

    public int getReadSize() {
        return this.writeCursor - this.readCursor;
    }
}

