/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import org.jfree.fonts.awt.AWTFontFamily;
import org.jfree.fonts.awt.AWTFontMetricsFactory;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;

public class AWTFontRegistry
implements FontRegistry {
    private HashMap fontFamilyCache = new HashMap();

    public void initialize() {
    }

    public FontMetricsFactory createMetricsFactory() {
        return new AWTFontMetricsFactory();
    }

    public synchronized FontFamily getFontFamily(String name) {
        AWTFontFamily fontFamily = (AWTFontFamily)this.fontFamilyCache.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        AWTFontFamily awtFontFamily = new AWTFontFamily(name);
        this.fontFamilyCache.put(name, awtFontFamily);
        return awtFontFamily;
    }

    public String[] getRegisteredFamilies() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return genv.getAvailableFontFamilyNames();
    }

    public String[] getAllRegisteredFamilies() {
        return this.getRegisteredFamilies();
    }
}

