/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jfree.fonts.encoding.CodePointUtilities;
import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.tools.StrictGeomUtility;

public class AWTFontMetrics
implements FontMetrics {
    private static final Graphics2D[] graphics = new Graphics2D[4];
    private Font font;
    private java.awt.FontMetrics fontMetrics;
    private long maxCharAdvance;
    private char[] cpBuffer;
    private FontRenderContext frc;
    private long xheight;
    private long ascent;
    private long descent;
    private long[] cachedWidths;
    private BaselineInfo[] cachedBaselines;

    public AWTFontMetrics(Font font, FontContext context) {
        this.font = font;
        this.frc = new FontRenderContext(null, context.isAntiAliased(), context.isFractionalMetrics());
        Graphics2D graphics = this.createGraphics(context);
        this.fontMetrics = graphics.getFontMetrics(font);
        Rectangle2D rect = this.font.getMaxCharBounds(this.frc);
        this.maxCharAdvance = StrictGeomUtility.toInternalValue(rect.getWidth());
        this.ascent = StrictGeomUtility.toInternalValue(-rect.getY());
        this.descent = StrictGeomUtility.toInternalValue(rect.getHeight() + rect.getY());
        GlyphVector gv = font.createGlyphVector(this.frc, "x");
        Rectangle2D bounds = gv.getVisualBounds();
        this.xheight = StrictGeomUtility.toInternalValue(bounds.getHeight());
        this.cpBuffer = new char[4];
        this.cachedBaselines = new BaselineInfo[224];
        this.cachedWidths = new long[224];
        Arrays.fill(this.cachedWidths, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Graphics2D createGraphics(FontContext context) {
        int idx = 0;
        if (context.isAntiAliased()) {
            ++idx;
        }
        if (context.isFractionalMetrics()) {
            idx += 2;
        }
        Graphics2D[] graphics2DArray = graphics;
        synchronized (graphics) {
            Graphics2D retval = graphics[idx];
            if (retval == null) {
                BufferedImage image = new BufferedImage(1, 1, 2);
                Graphics2D g2 = image.createGraphics();
                if (context.isAntiAliased()) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (context.isFractionalMetrics()) {
                    g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                }
                AWTFontMetrics.graphics[idx] = g2;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return g2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return retval;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getDescent() {
        return this.descent;
    }

    public long getLeading() {
        return StrictGeomUtility.toInternalValue(this.fontMetrics.getLeading());
    }

    public long getXHeight() {
        return this.xheight;
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.getMaxHeight() / 20L);
    }

    public long getUnderlinePosition() {
        return this.getLeading() + this.getMaxAscent() + Math.max(1000L, this.getMaxHeight() / 20L);
    }

    public long getStrikeThroughPosition() {
        return this.getMaxAscent() - (long)(0.5 * (double)this.getXHeight());
    }

    public long getMaxAscent() {
        return StrictGeomUtility.toInternalValue(this.fontMetrics.getMaxAscent());
    }

    public long getMaxDescent() {
        return StrictGeomUtility.toInternalValue(this.fontMetrics.getMaxDescent());
    }

    public long getMaxHeight() {
        return this.getMaxAscent() + this.getMaxDescent() + this.getLeading();
    }

    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }

    public synchronized long getCharWidth(int character) {
        if (character >= 32 && character < 256) {
            int index = character - 32;
            long cachedWidth = this.cachedWidths[index];
            if (cachedWidth >= 0L) {
                return cachedWidth;
            }
            int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
            if (retval > 0) {
                long width;
                Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
                this.cachedWidths[index] = width = StrictGeomUtility.toInternalValue(lm.getWidth());
                return width;
            }
            this.cachedWidths[index] = 0L;
            return 0L;
        }
        int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
        if (retval > 0) {
            Rectangle2D lm = this.font.getStringBounds(this.cpBuffer, 0, retval, this.frc);
            return StrictGeomUtility.toInternalValue(lm.getWidth());
        }
        return 0L;
    }

    public synchronized long getKerning(int previous, int character) {
        int retvalC1 = CodePointUtilities.toChars(previous, this.cpBuffer, 0);
        if (retvalC1 <= 0) {
            return 0L;
        }
        int retvalC2 = CodePointUtilities.toChars(character, this.cpBuffer, retvalC1);
        if (retvalC2 > 0) {
            int limit = retvalC1 + retvalC2;
            GlyphVector gv = this.font.createGlyphVector(this.frc, new String(this.cpBuffer, 0, limit));
            long totalSize = StrictGeomUtility.toInternalValue(gv.getGlyphPosition(limit).getX());
            long renderedWidth = StrictGeomUtility.toInternalValue(gv.getOutline().getBounds2D().getWidth());
            return totalSize - renderedWidth;
        }
        return 0L;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        BaselineInfo fromCache;
        boolean cacheable;
        boolean bl = cacheable = c >= 32 && c < 256;
        if (cacheable && (fromCache = this.cachedBaselines[c - 32]) != null) {
            if (info == null) {
                info = new BaselineInfo();
            }
            info.update(fromCache);
            return info;
        }
        this.cpBuffer[0] = (char)(c & 0xFFFF);
        LineMetrics lm = this.font.getLineMetrics(this.cpBuffer, 0, 1, this.frc);
        float[] bls = lm.getBaselineOffsets();
        int idx = lm.getBaselineIndex();
        if (info == null) {
            info = new BaselineInfo();
        }
        long maxAscent = this.getMaxAscent();
        long ascent = StrictGeomUtility.toInternalValue(lm.getAscent());
        long delta = maxAscent - ascent;
        info.setBaseline(1, delta + maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2L);
        long base = delta + ascent;
        switch (idx) {
            case 1: {
                info.setBaseline(2, base);
                info.setBaseline(4, base + StrictGeomUtility.toInternalValue(bls[0]));
                info.setBaseline(0, base + StrictGeomUtility.toInternalValue(bls[2]));
                info.setDominantBaseline(2);
                break;
            }
            case 2: {
                info.setBaseline(2, base + StrictGeomUtility.toInternalValue(bls[1]));
                info.setBaseline(4, base + StrictGeomUtility.toInternalValue(bls[0]));
                info.setBaseline(0, base);
                info.setDominantBaseline(0);
                break;
            }
            default: {
                info.setBaseline(4, base);
                info.setBaseline(2, base + StrictGeomUtility.toInternalValue(bls[1]));
                info.setBaseline(0, base + StrictGeomUtility.toInternalValue(bls[2]));
                info.setDominantBaseline(4);
            }
        }
        if (cacheable) {
            BaselineInfo cached = new BaselineInfo();
            cached.update(info);
            this.cachedBaselines[c - 32] = cached;
        }
        return info;
    }

    public long getItalicAngle() {
        return 0L;
    }
}

