/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.afm;

import java.io.IOException;
import java.util.StringTokenizer;

public class AfmParseUtilities {
    private AfmParseUtilities() {
    }

    public static int parseInt(String key, String wholeLine) throws IOException {
        try {
            return Integer.parseInt(wholeLine.substring(key.length()).trim());
        }
        catch (Exception e) {
            throw new IOException("Failed to parse value for Line '" + wholeLine + '\'');
        }
    }

    public static double parseDouble(String key, String wholeLine) throws IOException {
        try {
            return Double.parseDouble(wholeLine.substring(key.length()).trim());
        }
        catch (Exception e) {
            throw new IOException("Failed to parse value for Line '" + wholeLine + '\'');
        }
    }

    public static double[] parseDoubleArray(String line, int size) throws IOException {
        StringTokenizer strtok = new StringTokenizer(line);
        if (strtok.countTokens() != size + 1) {
            throw new IOException("Invalid array specification: " + line);
        }
        strtok.nextToken();
        try {
            double[] retval = new double[size];
            for (int i = 0; i < size; ++i) {
                retval[i] = Double.parseDouble(strtok.nextToken());
            }
            return retval;
        }
        catch (Exception e) {
            throw new IOException("Invalid array specification: " + line);
        }
    }
}

