/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.afm;

import java.io.IOException;
import org.jfree.fonts.afm.AfmParseUtilities;

public class AfmHeader {
    private static final String METRICS_SETS = "MetricsSets ";
    private static final String FONT_NAME = "FontName ";
    private static final String FULL_NAME = "FullName ";
    private static final String FAMILY_NAME = "FamilyName ";
    private static final String WEIGHT = "Weight ";
    private static final String FONT_BBOX = "FontBBox ";
    private static final String VERSION = "Version ";
    private static final String NOTICE = "Notice ";
    private static final String ENCODING_SCHEME = "EncodingScheme ";
    private static final String MAPPING_SCHEME = "MappingScheme ";
    private static final String ESC_CHAR = "EscChar ";
    private static final String CHARACTERSET = "CharacterSet ";
    private static final String CHARACTERS = "Characters ";
    private static final String ISBASEFONT = "IsBaseFont ";
    private static final String VVECTOR = "VVector ";
    private static final String ISFIXEDV = "IsFixedV ";
    private static final String CAPHEIGHT = "CapHeight ";
    private static final String XHEIGHT = "XHeight ";
    private static final String ASCENDER = "Ascender ";
    private static final String DESCENDER = "Descender ";
    private String fontName;
    private int metricsSets;
    private String familyName;
    private String fullName;
    private int weight;
    private double[] bbox;
    private String version;
    private String notice;
    private String encodingScheme;
    private int mappingScheme;
    private int escChar;
    private String characterSet;
    private int characters;
    private boolean baseFont;
    private double[] vvector;
    private boolean fixedV;
    private double capHeight;
    private double xHeight;
    private double ascender;
    private double descender;

    public void addData(String line) throws IOException {
        if (line.startsWith(METRICS_SETS)) {
            this.metricsSets = AfmParseUtilities.parseInt(METRICS_SETS, line);
        } else if (line.startsWith(FONT_NAME)) {
            this.fontName = line.substring(FONT_NAME.length());
        } else if (line.startsWith(FULL_NAME)) {
            this.fullName = line.substring(FULL_NAME.length());
        } else if (line.startsWith(FAMILY_NAME)) {
            this.familyName = line.substring(FAMILY_NAME.length());
        } else if (line.startsWith(WEIGHT)) {
            String weightText = line.substring(WEIGHT.length());
            this.weight = "bold".equalsIgnoreCase(weightText) ? 700 : ("light".equalsIgnoreCase(weightText) ? 200 : 400);
        } else if (line.startsWith(FONT_BBOX)) {
            this.bbox = AfmParseUtilities.parseDoubleArray(line, 4);
        } else if (line.startsWith(VERSION)) {
            this.version = line.substring(VERSION.length());
        } else if (line.startsWith(NOTICE)) {
            this.notice = line.substring(NOTICE.length());
        } else if (line.startsWith(ENCODING_SCHEME)) {
            this.encodingScheme = line.substring(ENCODING_SCHEME.length());
        } else if (line.startsWith(MAPPING_SCHEME)) {
            this.mappingScheme = AfmParseUtilities.parseInt(MAPPING_SCHEME, line);
        } else if (line.startsWith(ESC_CHAR)) {
            this.escChar = AfmParseUtilities.parseInt(ESC_CHAR, line);
        } else if (line.startsWith(CHARACTERSET)) {
            this.characterSet = line.substring(CHARACTERSET.length());
        } else if (line.startsWith(CHARACTERS)) {
            this.characters = AfmParseUtilities.parseInt(CHARACTERS, line);
        } else if (line.startsWith(ISBASEFONT)) {
            String baseFontText = line.substring(ISBASEFONT.length());
            this.baseFont = "true".equalsIgnoreCase(baseFontText);
        } else if (line.startsWith(VVECTOR)) {
            this.vvector = AfmParseUtilities.parseDoubleArray(line, 2);
        } else if (line.startsWith(ISFIXEDV)) {
            String boolText = line.substring(ISFIXEDV.length());
            this.fixedV = "true".equalsIgnoreCase(boolText);
        } else if (line.startsWith(CAPHEIGHT)) {
            this.capHeight = AfmParseUtilities.parseDouble(CAPHEIGHT, line);
        } else if (line.startsWith(XHEIGHT)) {
            this.xHeight = AfmParseUtilities.parseDouble(XHEIGHT, line);
        } else if (line.startsWith(ASCENDER)) {
            this.ascender = AfmParseUtilities.parseDouble(ASCENDER, line);
        } else if (line.startsWith(DESCENDER)) {
            this.descender = AfmParseUtilities.parseDouble(DESCENDER, line);
        }
    }

    public double getDescender() {
        return this.descender;
    }

    public double getAscender() {
        return this.ascender;
    }

    public double getxHeight() {
        return this.xHeight;
    }

    public double getCapHeight() {
        return this.capHeight;
    }

    public boolean isFixedV() {
        return this.fixedV;
    }

    public double[] getVvector() {
        if (this.vvector == null) {
            return null;
        }
        return (double[])this.vvector.clone();
    }

    public boolean isBaseFont() {
        return this.baseFont;
    }

    public int getCharacters() {
        return this.characters;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public int getEscChar() {
        return this.escChar;
    }

    public int getMappingScheme() {
        return this.mappingScheme;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getVersion() {
        return this.version;
    }

    public double[] getBbox() {
        if (this.bbox == null) {
            return null;
        }
        return (double[])this.bbox.clone();
    }

    public int getWeight() {
        return this.weight;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getMetricsSets() {
        return this.metricsSets;
    }

    public String getFontName() {
        return this.fontName;
    }
}

