/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.afm;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import org.jfree.fonts.afm.AfmFont;
import org.jfree.fonts.afm.AfmFontRecord;
import org.jfree.fonts.registry.AbstractFontFileRegistry;
import org.jfree.fonts.registry.DefaultFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.util.Log;
import org.jfree.util.StringUtils;

public class AfmFontRegistry
extends AbstractFontFileRegistry {
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();
    private HashMap seenFiles = new HashMap();

    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    public FontMetricsFactory createMetricsFactory() {
        throw new UnsupportedOperationException();
    }

    protected boolean isCached(File file) {
        return super.isCached(file);
    }

    public void addFont(File font, String encoding) throws IOException {
        if (this.seenFiles.containsKey(font)) {
            return;
        }
        String fileName = font.getCanonicalPath();
        String filePfbName = fileName.substring(0, fileName.length() - 3) + "pfb";
        File filePfb = new File(filePfbName);
        boolean embedded = true;
        if (!(filePfb.exists() && filePfb.isFile() && filePfb.canRead())) {
            Log.warn((Object)("Cannot embedd font: " + filePfb + " is missing for " + font));
            embedded = false;
        }
        AfmFont pfmFont = new AfmFont(font, embedded);
        this.registerFont(pfmFont);
        pfmFont.dispose();
    }

    private void registerFont(AfmFont font) throws IOException {
        String windowsName = font.getFamilyName();
        String postscriptName = font.getFontName();
        DefaultFontFamily fontFamily = this.createFamily(windowsName);
        this.alternateFamilyNames.put(windowsName, fontFamily);
        this.alternateFamilyNames.put(postscriptName, fontFamily);
        this.fullFontNames.put(windowsName, fontFamily);
        this.fullFontNames.put(postscriptName, fontFamily);
        AfmFontRecord record = new AfmFontRecord(font, fontFamily);
        fontFamily.addFontRecord(record);
    }

    private DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = (DefaultFontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        DefaultFontFamily createdFamily = new DefaultFontFamily(name);
        this.fontFamilies.put(name, createdFamily);
        return createdFamily;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    public FontFamily getFontFamily(String name) {
        FontFamily primary = (FontFamily)this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = (FontFamily)this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return (FontFamily)this.fullFontNames.get(name);
    }

    private static class FontPathFilter
    implements FileFilter {
        protected FontPathFilter() {
        }

        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            return StringUtils.endsWithIgnoreCase((String)name, (String)".afm");
        }
    }
}

