/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.afm;

import org.jfree.fonts.afm.AfmFont;
import org.jfree.fonts.afm.AfmHeader;
import org.jfree.fonts.io.FontDataInputSource;
import org.jfree.fonts.registry.DefaultFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontSource;
import org.jfree.fonts.registry.FontType;

public class AfmFontRecord
implements FontSource,
FontIdentifier {
    private AfmFont font;
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;

    public AfmFontRecord(AfmFont font, DefaultFontFamily fontFamily) {
        if (font == null) {
            throw new NullPointerException();
        }
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.font = font;
        this.fontFamily = fontFamily;
        AfmHeader header = font.getHeader();
        this.bold = header.getWeight() > 400;
        this.italic = font.getDirectionSection(0).getItalicAngle() != 0.0;
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isOblique() {
        return false;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public String getFontFile() {
        return this.font.getFilename();
    }

    public FontDataInputSource getFontInputSource() {
        return this.font.getInput();
    }

    public boolean isEmbeddable() {
        return this.font.isEmbeddable();
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.AFM;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AfmFontRecord that = (AfmFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italic != that.italic) {
            return false;
        }
        if (!this.font.equals(that.font)) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    public int hashCode() {
        int result = this.font.hashCode();
        result = 29 * result + this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italic ? 1 : 0);
        return result;
    }
}

