/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.afm;

import java.io.IOException;
import org.jfree.fonts.afm.AfmParseUtilities;

public class AfmDirectionSection {
    private static final String START_LINE = "StartDirection ";
    private static final String UNDERLINE_POSITION = "UnderlinePosition ";
    private static final String UNDERLINE_THICKNESS = "UnderlineThickness ";
    private static final String ITALIC_ANGLE = "ItalicAngle ";
    private static final String CHARWIDTH = "CharWidth ";
    private static final String IS_FIXED_PITCH = "IsFixedPitch ";
    private double underlinePosition;
    private double underlineThickness;
    private double italicAngle;
    private double[] charWidth;
    private boolean fixedPitch;

    public void add(String line) throws IOException {
        if (line.startsWith(UNDERLINE_POSITION)) {
            this.underlinePosition = AfmParseUtilities.parseDouble(UNDERLINE_POSITION, line);
        } else if (line.startsWith(UNDERLINE_THICKNESS)) {
            this.underlineThickness = AfmParseUtilities.parseDouble(UNDERLINE_THICKNESS, line);
        } else if (line.startsWith(ITALIC_ANGLE)) {
            this.italicAngle = AfmParseUtilities.parseDouble(ITALIC_ANGLE, line);
        } else if (line.startsWith(CHARWIDTH)) {
            this.charWidth = AfmParseUtilities.parseDoubleArray(line, 2);
        } else if (line.startsWith(IS_FIXED_PITCH)) {
            String boolText = line.substring(IS_FIXED_PITCH.length());
            this.fixedPitch = "true".equalsIgnoreCase(boolText);
        }
    }

    public double getUnderlinePosition() {
        return this.underlinePosition;
    }

    public double getUnderlineThickness() {
        return this.underlineThickness;
    }

    public double getItalicAngle() {
        return this.italicAngle;
    }

    public double[] getCharWidth() {
        return this.charWidth;
    }

    public boolean isFixedPitch() {
        return this.fixedPitch;
    }
}

