/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts;

import org.jfree.fonts.encoding.ByteBuffer;
import org.jfree.fonts.encoding.CodePointBuffer;
import org.jfree.fonts.encoding.Encoding;
import org.jfree.fonts.encoding.EncodingException;
import org.jfree.fonts.encoding.EncodingRegistry;
import org.jfree.fonts.encoding.manual.Utf16LE;

public class ByteAccessUtilities {
    private ByteAccessUtilities() {
    }

    public static int readUShort(byte[] data, int pos) {
        return (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
    }

    public static long readULong(byte[] data, int pos) {
        int c1 = data[pos] & 0xFF;
        int c2 = data[pos + 1] & 0xFF;
        int c3 = data[pos + 2] & 0xFF;
        int c4 = data[pos + 3] & 0xFF;
        long retval = (long)c1 << 24;
        retval |= (long)c2 << 16;
        retval |= (long)c3 << 8;
        return retval |= (long)c4;
    }

    public static float readFixed(byte[] data, int pos) {
        short mantissa = ByteAccessUtilities.readShort(data, pos);
        int fraction = ByteAccessUtilities.readUShort(data, pos + 2);
        if (fraction == 0 || mantissa == 0) {
            return 0.0f;
        }
        return (float)mantissa / ((float)fraction / 16384.0f);
    }

    public static long readLongDateTime(byte[] data, int pos) {
        int c1 = data[pos] & 0xFF;
        int c2 = data[pos + 1] & 0xFF;
        int c3 = data[pos + 2] & 0xFF;
        int c4 = data[pos + 3] & 0xFF;
        int c5 = data[pos + 4] & 0xFF;
        int c6 = data[pos + 5] & 0xFF;
        int c7 = data[pos + 6] & 0xFF;
        int c8 = data[pos + 7] & 0xFF;
        long retval = (long)c1 << 56;
        retval |= (long)c2 << 48;
        retval |= (long)c3 << 40;
        retval |= (long)c4 << 32;
        retval |= (long)c5 << 24;
        retval |= (long)c6 << 16;
        retval |= (long)c7 << 8;
        return retval |= (long)c8;
    }

    public static byte[] readBytes(byte[] data, int pos, int length) {
        byte[] retval = new byte[length];
        System.arraycopy(data, pos, retval, 0, length);
        return retval;
    }

    public static short readShort(byte[] data, int pos) {
        return (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
    }

    public static int readLong(byte[] data, int pos) {
        int retval = 0;
        retval = (int)((long)retval | (long)(data[pos] & 0xFF) << 24);
        retval = (int)((long)retval | (long)(data[pos + 1] & 0xFF) << 16);
        retval = (int)((long)retval | (long)(data[pos + 2] & 0xFF) << 8);
        retval = (int)((long)retval | (long)(data[pos + 3] & 0xFF));
        return retval;
    }

    public static int readZStringOffset(byte[] data, int pos, int maxLength) {
        int lastPos = Math.min(pos + maxLength, pos + data.length);
        for (int i = pos; i < lastPos; ++i) {
            if (data[i] != 0) continue;
            return i;
        }
        return lastPos;
    }

    public static String readZString(byte[] data, int pos, int maxLength, String encoding) throws EncodingException {
        int lastPos = Math.min(pos + maxLength, pos + data.length);
        for (int i = pos; i < lastPos; ++i) {
            if (data[i] != 0) continue;
            return ByteAccessUtilities.readString(data, pos, i - pos, encoding);
        }
        return ByteAccessUtilities.readString(data, pos, lastPos, encoding);
    }

    public static String readString(byte[] data, int pos, int length, String encoding) throws EncodingException {
        Encoding enc = "UTF-16".equals(encoding) ? EncodingRegistry.getInstance().getEncoding("UTF-16LE") : EncodingRegistry.getInstance().getEncoding(encoding);
        ByteBuffer byteBuffer = new ByteBuffer(data, pos, length);
        CodePointBuffer cp = enc.decode(byteBuffer, null);
        return Utf16LE.getInstance().encodeString(cp);
    }
}

