/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import java.io.BufferedWriter;
import java.io.IOException;

public class OutputHandler {
    private static final String EMPTY = "";
    public static BufferedWriter logFile;
    public static boolean doLog;
    public static boolean doDebug;
    public static BufferedWriter dbgFile;

    static final void out(String string) {
        try {
            if (doDebug) {
                OutputHandler.dbg(string);
            }
            if (!doLog || logFile == null) {
                System.out.println(string);
            } else {
                System.out.println(string);
                if (EMPTY.equals(string)) {
                    OutputHandler.log(EMPTY);
                } else {
                    OutputHandler.log(string);
                }
            }
        }
        catch (IOException iOException) {
            OutputHandler.log(iOException.toString());
        }
    }

    static final void printDot() {
        System.out.print(".");
    }

    static final void log(String string) {
        try {
            if (string == null) {
                return;
            }
            if (doDebug) {
                OutputHandler.dbg(string);
            }
            if (doLog) {
                if (!EMPTY.equals(string)) {
                    logFile.write(string);
                }
                logFile.newLine();
                logFile.flush();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    static final void dbg(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (doDebug) {
            if (!EMPTY.equals(string)) {
                dbgFile.write(string);
            }
            dbgFile.newLine();
            dbgFile.flush();
        }
    }

    private static void setDebug(boolean bl) {
        doDebug = bl;
    }

    private static void setDbgFile(BufferedWriter bufferedWriter) {
        dbgFile = bufferedWriter;
    }

    private static BufferedWriter getDbgFile() {
        return dbgFile;
    }

    private static void setLog(boolean bl) {
        doLog = bl;
    }

    private static boolean isLog() {
        return doLog;
    }

    private static void setLogFile(BufferedWriter bufferedWriter) {
        logFile = bufferedWriter;
    }

    private static BufferedWriter getLogFile() {
        return logFile;
    }

    public static void closeAll() throws IOException {
        if (logFile != null) {
            logFile.flush();
            logFile.close();
        }
        if (dbgFile != null) {
            dbgFile.flush();
            dbgFile.close();
        }
    }

    static {
        doLog = false;
        doDebug = false;
    }
}

