/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.DirtyTags.DirtyTagWrapper;
import com.sun.star.tooling.converter.Converter;
import com.sun.star.tooling.converter.ConverterException;
import com.sun.star.tooling.converter.FileMaker;
import com.sun.star.tooling.converter.OutputHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;

public class Convert {
    private static Calendar cal;
    private static final String EMPTY = "";
    private static String dbgName;
    private static final char extensionSeperator = '.';
    private static File log;
    private static String logString;
    private static boolean overwrite;
    private static File secondSource;
    private static String sourceLanguage;
    private static String sourceName;
    private static String sourceType;
    private static String startTime;
    private static String TargetLanguage;
    private static String targetName;
    private static String targetType;
    static final String version = " Prod.20050710:1255 ";
    private static String secondSourceName;
    private static boolean doWrap;

    public static void main(String[] stringArray) throws IOException, Exception {
        try {
            ParameterChecker.checkClParameters(stringArray);
            ParameterChecker.createContentOfClParameters();
            DirtyTagWrapper.setWrapping(doWrap);
            Converter converter = new Converter(sourceType, sourceName, sourceLanguage, targetType, targetName, TargetLanguage, secondSourceName, overwrite);
            cal = Calendar.getInstance();
            startTime = cal.getTime().toString();
            Convert.printPreamble();
            converter.convert();
            Convert.showStatistic();
            OutputHandler.closeAll();
        }
        catch (Exception exception) {
            System.out.print("An EXCEPTION occured, please check your commad line settings \n" + exception.getMessage());
            System.exit(-1);
        }
        catch (Throwable throwable) {
            System.out.print("A FATAL ERROR occured, please check your commad line settings \n" + throwable.getMessage());
            System.exit(-1);
        }
    }

    private static void printHelp() {
        String string = System.getProperty("line.separator");
        System.out.println("File Converting Tool 'converter' Version  Prod.20050710:1255 " + string + "Converts SDF files to wellformed XLIFF or GSI files and vice versa" + string + string + "Use: " + string + "convert [-h]|[SourcePath [TargetPath] [-T Type] [[-S Type [secondSourcePath]]  " + string + "        [-s LanguageID] [-t LanguageID] [-l [LogPath]] [-o]]" + string + string + "-h               show this help." + string + "SourcePath       path of the file to convert." + string + "secondSourcePath path of the SDF file to merge to (GSI -> SDF only!)." + string + "TargetPath       path where to store the result." + string + "LogPath          path of the log file" + string + "-T Type          the type of the target file (xliff,sdf,gsi)" + string + "-S Type          the type of the source file (xliff,sdf,gsi)" + string + "-s LanguageID    the ISO language code of the source language (de, fr...)." + string + "                 Default is 'en-US' " + string + "-t LanguageID    the language code of the target language (de, fr...)." + string + "                 Default is first found Language other than source language." + string + "-l [LogPath]     write a log file,  you can name the file." + string + "-o               overwrite existing files without asking." + string + "-nw              disable the wrapping with ept/bpt tags." + string + string + "The created files were stored in the SourceFile Path if nothing else is given. " + string + "The extension is '.xliff','.sdf' depending on the source file and '.log' " + string + "for the logfile." + string);
    }

    private static final void printPreamble() throws IOException {
        OutputHandler.out(EMPTY);
        OutputHandler.out("Source File is: " + sourceName);
        OutputHandler.out("Target File is: " + targetName);
        if (OutputHandler.doLog) {
            OutputHandler.out("Log File    is: " + logString);
        } else {
            OutputHandler.out("Log File    is: disabled");
        }
        OutputHandler.out(EMPTY);
    }

    private static final void showStatistic() throws IOException {
        OutputHandler.dbg(EMPTY);
        OutputHandler.out((targetType.equalsIgnoreCase("xliff") ? "TransUnits written:   " : "Lines written :         ") + Converter.getLineCounter());
        OutputHandler.dbg(EMPTY);
        OutputHandler.out("Started    at :         " + startTime);
        cal = Calendar.getInstance();
        OutputHandler.out("Finished   at :         " + cal.getTime());
        OutputHandler.dbg(EMPTY);
    }

    protected static String extractExtension(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2;
    }

    static {
        dbgName = EMPTY;
        logString = EMPTY;
        overwrite = false;
        sourceLanguage = "en-US";
        sourceName = EMPTY;
        sourceType = EMPTY;
        startTime = EMPTY;
        TargetLanguage = EMPTY;
        targetName = EMPTY;
        targetType = EMPTY;
        secondSourceName = EMPTY;
        doWrap = true;
    }

    private static class ParameterChecker {
        private static String filePath;
        private static String fileName;

        private static void checkClParameters(String[] stringArray) throws IOException {
            try {
                if (stringArray.length == 0) {
                    Convert.printHelp();
                    System.exit(-1);
                }
                if (stringArray[0].equals("-h")) {
                    Convert.printHelp();
                    System.exit(0);
                }
                if (stringArray[0].equals("-ver")) {
                    System.out.println("File Converting Tool Version  Prod.20050710:1255 ");
                    System.exit(0);
                }
                sourceName = new String(stringArray[0]);
                File file = new File(sourceName);
                if (!file.exists()) {
                    throw new IOException("ERROR:Can not find Source File '" + sourceName + "'. Aborting...");
                }
                filePath = file.getParent() == null ? Convert.EMPTY : file.getParent() + File.separator;
                fileName = file.getName().substring(0, file.getName().lastIndexOf(46));
                for (int i = 1; i < stringArray.length; ++i) {
                    if ("-s".equals(stringArray[i])) {
                        if (stringArray.length > i + 1) {
                            sourceLanguage = stringArray[++i];
                            continue;
                        }
                        throw new ConverterException("missing argument for -s source language");
                    }
                    if ("-S".equals(stringArray[i])) {
                        if (stringArray.length > i + 1) {
                            sourceType = stringArray[++i];
                            if (stringArray.length <= i + 1 || stringArray[i + 1].startsWith("-")) continue;
                            secondSourceName = stringArray[++i];
                            continue;
                        }
                        throw new ConverterException("missing argument for -S  source type");
                    }
                    if ("-T".equals(stringArray[i])) {
                        if (stringArray.length > i + 1) {
                            targetType = stringArray[++i];
                            continue;
                        }
                        throw new ConverterException("missing argument for -T  target type");
                    }
                    if ("-l".equals(stringArray[i])) {
                        OutputHandler.doLog = true;
                        if (stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                            logString = stringArray[++i];
                            continue;
                        }
                        logString = Convert.EMPTY;
                        continue;
                    }
                    if ("-o".equals(stringArray[i])) {
                        overwrite = true;
                        continue;
                    }
                    if ("-nw".equals(stringArray[i])) {
                        doWrap = false;
                        continue;
                    }
                    if ("-h".equals(stringArray[i])) {
                        Convert.printHelp();
                        System.exit(0);
                    }
                    if ("-dbg".equals(stringArray[i])) {
                        OutputHandler.doDebug = true;
                        continue;
                    }
                    if ("-t".equals(stringArray[i])) {
                        if (stringArray.length > i + 1) {
                            TargetLanguage = stringArray[++i];
                            continue;
                        }
                        throw new ConverterException("missing argument for -t  target language");
                    }
                    if (i == 1 && !stringArray[i].startsWith("-")) {
                        targetName = stringArray[i];
                        continue;
                    }
                    throw new ConverterException("unknown Attribute: " + stringArray[i]);
                }
            }
            catch (ConverterException converterException) {
                OutputHandler.out("ERROR: " + converterException.getMessage());
                System.exit(-1);
            }
            catch (Throwable throwable) {
                System.out.print("An Error occured while parsing the command line,\n please check your commad line settings.\n " + throwable.getMessage());
                System.exit(-1);
            }
        }

        private static void createContentOfClParameters() throws IOException {
            try {
                if (OutputHandler.doDebug) {
                    OutputHandler.dbgFile = new BufferedWriter(new FileWriter(new File(new String(filePath + fileName + ".dbg"))));
                }
                if (OutputHandler.doLog) {
                    if (Convert.EMPTY.equals(logString) || logString == null) {
                        logString = new String(ParameterChecker.filePath + ParameterChecker.fileName + ".log");
                    }
                    log = FileMaker.newFile(logString, overwrite);
                    OutputHandler.logFile = new BufferedWriter(new FileWriter(log));
                }
                if (Convert.EMPTY.equals(sourceType) || sourceType == null) {
                    if (!Convert.EMPTY.equals(sourceName) && sourceName != null) {
                        sourceType = Convert.extractExtension(sourceName);
                    } else {
                        throw new ConverterException("Source type is missing");
                    }
                }
                if (sourceType.equalsIgnoreCase("gsi") && Convert.EMPTY.equals(secondSourceName)) {
                    secondSourceName = ParameterChecker.filePath + ParameterChecker.fileName + ".sdf";
                }
                if (Convert.EMPTY.equals(sourceName)) {
                    sourceName = ParameterChecker.filePath + ParameterChecker.fileName + "." + sourceType;
                }
                if (Convert.EMPTY.equals(targetType) || targetType == null) {
                    if (!Convert.EMPTY.equals(targetName) && targetName != null) {
                        targetType = Convert.extractExtension(targetName);
                    } else {
                        throw new ConverterException("Target type is missing");
                    }
                }
                if (Convert.EMPTY.equals(targetName) || targetName == null) {
                    targetName = ParameterChecker.filePath + ParameterChecker.fileName + "." + targetType;
                    if (targetName.equals(secondSourceName)) {
                        OutputHandler.out("ERROR: \nSource '" + secondSourceName + "' and \nTarget'" + targetName + "' are the same");
                        System.exit(0);
                    } else if (targetName.equals(sourceName)) {
                        OutputHandler.out("ERROR: \nSource '" + sourceName + "' and \nTarget'" + targetName + "' are the same");
                        System.exit(0);
                    }
                } else if (targetName.equals(secondSourceName)) {
                    OutputHandler.out("ERROR: \nSource '" + secondSourceName + "' and \nTarget'" + targetName + "' are the same");
                    System.exit(0);
                } else if (targetName.equals(sourceName)) {
                    OutputHandler.out("ERROR: \nSource '" + sourceName + "' and \nTarget'" + targetName + "' are the same");
                    System.exit(0);
                }
            }
            catch (ConverterException converterException) {
                OutputHandler.out(converterException.getMessage());
            }
        }
    }
}

