/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.zipwriter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.jfree.repository.zipwriter.ZipContentItem;
import org.jfree.repository.zipwriter.ZipRepository;

public class ZipEntryOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private DeflaterOutputStream deflaterOutputStream;
    private boolean closed;
    private ZipContentItem item;

    public ZipEntryOutputStream(ZipContentItem item) {
        this.item = item;
        this.outputStream = new ByteArrayOutputStream();
        this.deflaterOutputStream = new DeflaterOutputStream(this.outputStream);
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.close();
        byte[] data = this.outputStream.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        InflaterInputStream infi = new InflaterInputStream(bin);
        ZipRepository repository = (ZipRepository)this.item.getRepository();
        String contentId = (String)this.item.getContentId();
        repository.writeContent(new ZipEntry(contentId), infi);
        infi.close();
        this.outputStream = null;
        this.deflaterOutputStream = null;
    }

    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.flush();
    }
}

