/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.RepositoryUtilities;
import org.jfree.repository.zipwriter.ZipContentLocation;
import org.jfree.repository.zipwriter.ZipEntryOutputStream;
import org.jfree.repository.zipwriter.ZipRepository;

public class ZipContentItem
implements ContentItem {
    private boolean newItem;
    private String name;
    private String contentId;
    private ZipRepository repository;
    private ZipContentLocation parent;

    public ZipContentItem(String name, ZipRepository repository, ZipContentLocation parent) {
        this.name = name;
        this.repository = repository;
        this.parent = parent;
        this.contentId = RepositoryUtilities.buildName(this, "/");
        this.newItem = true;
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        if (!this.newItem) {
            throw new ContentIOException("This item is no longer writeable.");
        }
        this.newItem = false;
        return new ZipEntryOutputStream(this);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        throw new ContentIOException("This item is not readable.");
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return this.newItem;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String domain, String key) {
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        return false;
    }
}

