/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.stream.WrappedInputStream;
import org.jfree.repository.stream.WrappedOutputStream;

public class StreamContentItem
implements ContentItem {
    private WrappedInputStream inputStream;
    private WrappedOutputStream outputStream;
    private ContentLocation parent;
    private String name;

    public StreamContentItem(String name, ContentLocation parent, WrappedInputStream inputStream, WrappedOutputStream outputStream) {
        this.name = name;
        this.parent = parent;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public boolean isReadable() {
        if (this.inputStream == null) {
            return false;
        }
        return !this.inputStream.isClosed();
    }

    public boolean isWriteable() {
        if (this.outputStream == null) {
            return false;
        }
        return !this.outputStream.isClosed();
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return this.outputStream;
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.name;
    }

    public Object getAttribute(String domain, String key) {
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    public boolean delete() {
        return false;
    }
}

