/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.file;

import java.io.File;
import java.util.Date;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;

public abstract class FileContentEntity
implements ContentEntity {
    private File backend;
    private ContentLocation parent;
    private Repository repository;

    protected FileContentEntity(ContentLocation parent, File backend) {
        this.repository = parent.getRepository();
        this.parent = parent;
        this.backend = backend;
    }

    protected FileContentEntity(Repository repository, File backend) {
        this.repository = repository;
        this.backend = backend;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.backend.getName();
    }

    protected File getBackend() {
        return this.backend;
    }

    public Object getContentId() {
        return this.getName();
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.backend.length());
            }
            if ("version".equals(key)) {
                return new Date(this.backend.lastModified());
            }
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain) && "version".equals(key)) {
            if (value instanceof Date) {
                Date date = (Date)value;
                return this.backend.setLastModified(date.getTime());
            }
            if (value instanceof Number) {
                Number time = (Number)value;
                return this.backend.setLastModified(time.longValue());
            }
        }
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        return this.backend.delete();
    }
}

