/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;
import java.util.EmptyStackException;

public class IntList
implements Serializable,
Cloneable {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] data;
    private int size;
    private int increment;

    public IntList(int capacity) {
        this.data = new int[capacity];
        this.increment = capacity;
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            int[] newData = new int[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(int value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public void set(int index, int value) {
        this.ensureCapacity(index);
        this.data[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " is invalid");
        }
        return this.data[index];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        return this.data[this.size];
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[this.size - 1];
    }

    public final void push(int value) {
        this.add(value);
    }

    public int[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        return (int[])this.data.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        IntList intList = (IntList)super.clone();
        intList.data = (int[])this.data.clone();
        return intList;
    }
}

