/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7442871030874215436L;
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private HashMap namespaces;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap copy) {
        if (copy == null) {
            return;
        }
        if (copy.namespaces == null) {
            return;
        }
        this.namespaces = (HashMap)copy.namespaces.clone();
        Iterator entries = this.namespaces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            HashMap value = (HashMap)entry.getValue();
            entry.setValue(value.clone());
        }
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        AttributeMap map = (AttributeMap)super.clone();
        map.namespaces = (HashMap)this.namespaces.clone();
        Iterator entries = map.namespaces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            HashMap value = (HashMap)entry.getValue();
            entry.setValue(value.clone());
        }
        return map;
    }

    public synchronized void setAttribute(String namespace, String attribute, Object value) {
        HashMap attrs;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if ((attrs = (HashMap)this.namespaces.get(namespace)) == null) {
            if (value == null) {
                return;
            }
            HashMap<String, Object> newAtts = new HashMap<String, Object>();
            newAtts.put(attribute, value);
            this.namespaces.put(namespace, newAtts);
        } else if (value == null) {
            attrs.remove(attribute);
            if (attrs.isEmpty()) {
                this.namespaces.remove(namespace);
            }
        } else {
            attrs.put(attribute, value);
        }
    }

    public synchronized Object getAttribute(String namespace, String attribute) {
        if (this.namespaces == null) {
            return null;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return null;
        }
        return attrs.get(attribute);
    }

    public synchronized Object getFirstAttribute(String attribute) {
        if (this.namespaces == null) {
            return null;
        }
        Iterator entries = this.namespaces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            HashMap map = (HashMap)entry.getValue();
            Object val = map.get(attribute);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public synchronized Map getAttributes(String namespace) {
        if (this.namespaces == null) {
            return null;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return null;
        }
        return Collections.unmodifiableMap(attrs);
    }

    public synchronized String[] getNameSpaces() {
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }
}

