/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.layouting.input.style.keys.line.AlignmentBaseline;
import org.jfree.layouting.input.style.keys.line.DominantBaseline;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.text.DefaultExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class TextUtility {
    private TextUtility() {
    }

    public static int translateDominantBaseline(CSSValue baseline, int defaultValue) {
        if (baseline == null || CSSAutoValue.getInstance().equals(baseline)) {
            return defaultValue;
        }
        if (DominantBaseline.ALPHABETIC.equals(baseline)) {
            return 6;
        }
        if (DominantBaseline.CENTRAL.equals(baseline)) {
            return 3;
        }
        if (DominantBaseline.HANGING.equals(baseline)) {
            return 2;
        }
        if (DominantBaseline.IDEOGRAPHIC.equals(baseline)) {
            return 7;
        }
        if (DominantBaseline.MATHEMATICAL.equals(baseline)) {
            return 5;
        }
        if (DominantBaseline.MIDDLE.equals(baseline)) {
            return 4;
        }
        if (DominantBaseline.TEXT_AFTER_EDGE.equals(baseline)) {
            return 8;
        }
        if (DominantBaseline.TEXT_BEFORE_EDGE.equals(baseline)) {
            return 1;
        }
        return defaultValue;
    }

    public static int translateAlignmentBaseline(CSSValue baseline, int defaultValue) {
        if (baseline == null || CSSAutoValue.getInstance().equals(baseline)) {
            return defaultValue;
        }
        if (AlignmentBaseline.ALPHABETIC.equals(baseline)) {
            return 6;
        }
        if (AlignmentBaseline.CENTRAL.equals(baseline)) {
            return 3;
        }
        if (AlignmentBaseline.HANGING.equals(baseline)) {
            return 2;
        }
        if (AlignmentBaseline.IDEOGRAPHIC.equals(baseline)) {
            return 7;
        }
        if (AlignmentBaseline.MATHEMATICAL.equals(baseline)) {
            return 5;
        }
        if (AlignmentBaseline.MIDDLE.equals(baseline)) {
            return 4;
        }
        if (AlignmentBaseline.TEXT_AFTER_EDGE.equals(baseline)) {
            return 8;
        }
        if (AlignmentBaseline.TEXT_BEFORE_EDGE.equals(baseline)) {
            return 1;
        }
        if (AlignmentBaseline.AFTER_EDGE.equals(baseline)) {
            return 9;
        }
        if (AlignmentBaseline.BEFORE_EDGE.equals(baseline)) {
            return 0;
        }
        return defaultValue;
    }

    public static int translateBaselines(int baseline) {
        switch (baseline) {
            case 0: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 2: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 1: {
                return 5;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid baseline");
    }

    public static ExtendedBaselineInfo createBaselineInfo(int codepoint, FontMetrics fontMetrics) {
        BaselineInfo baselineInfo = fontMetrics.getBaselines(codepoint, null);
        int dominantBaseline = TextUtility.translateBaselines(baselineInfo.getDominantBaseline());
        DefaultExtendedBaselineInfo extBaselineInfo = new DefaultExtendedBaselineInfo(dominantBaseline);
        long[] baselines = new long[10];
        baselines[6] = baselineInfo.getBaseline(4);
        baselines[3] = baselineInfo.getBaseline(2);
        baselines[2] = baselineInfo.getBaseline(0);
        baselines[7] = baselineInfo.getBaseline(5);
        baselines[5] = baselineInfo.getBaseline(1);
        baselines[4] = baselineInfo.getBaseline(3);
        baselines[0] = 0L;
        baselines[1] = 0L;
        baselines[8] = fontMetrics.getMaxHeight();
        baselines[9] = baselines[8];
        extBaselineInfo.setBaselines(baselines);
        return extBaselineInfo;
    }
}

